//
//  Button.cpp
//  CliqueLeCubeIOS
//
//  Created by Pâris on 08/10/13.
//
//
#include "SDL.h"
#include "SDL_ttf.h"
#include "Button.h"

#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 960-40

extern SDL_Renderer* renderer;

Button::Button (const char* texte, TTF_Font* police, SDL_Rect pos, SDL_Color fg, SDL_Color bg)
{
    this->texte = (char*)texte;
    this->police = police;
    this->pos = pos;
    this->fg = fg;
    this->bg = bg;
	texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_STREAMING, 640, 480);
}

Button::~Button()
{
	SDL_DestroyTexture(texture);
}
void Button::sendEvent(SDL_Event e)
{
	if (e.type == SDL_FINGERUP || e.type == SDL_FINGERDOWN || e.type == SDL_FINGERMOTION)
		Default(this);
	if (e.type == SDL_FINGERDOWN && this->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
		hover(this);
	if(e.type == SDL_FINGERMOTION && this->isHover(e.tfinger.x*SCREEN_WIDTH, e.tfinger.y*SCREEN_HEIGHT))
		hover(this);
	
}
void Button::render(bool Center)
{
	SDL_DestroyTexture(texture);
    SDL_Surface* surface;
    surface = TTF_RenderText_Blended(police, texte, fg);
    info.h = surface->h;
    info.w = surface->w;
    info.x = pos.x;
    info.y = pos.y;
    texture = SDL_CreateTextureFromSurface(renderer, surface);
    

    rect.h = info.h + 10;
    rect.w = info.w + 10;
    rect.x = pos.x - 5;
    rect.y = pos.y - 5;
	if(Center)
	{
		pos.x -= rect.w/2;
		this->render(false);
	}
	SDL_FreeSurface(surface);
	
	
}
void Button::onHover(void (*callback)(Button*))
{
	this->hover = callback;
}
void Button::onDefault(void (*callback)(Button*))
{
	this->Default = callback;
}
void Button::setPosition(int x, int y)
{
    pos.x = x;
    pos.y = y;
}

void Button::changeBg(SDL_Color bg)
{
    this->bg = bg;
}
void Button::changeFg(SDL_Color fg)
{
	this->fg = fg;
}
void Button::changeText(const char* texte)
{
	this->texte = (char*)texte;
}
bool Button::isHover(int x, int y)
{
    return (x >= rect.x && y >= rect.y && x <= rect.x + rect.w && y <= rect.y + rect.h);
}

void Button::Draw()
{
    SDL_SetRenderDrawColor(renderer, bg.r, bg.g, bg.b, 255);
    SDL_RenderFillRect(renderer, &rect);
    
    SDL_RenderCopy(renderer, texture, NULL, &info);
}